# TODO:
#  - Open Ciros 7 or newer
#  - Create an empty model
#  - Open the EXTRAS/Python/Execute... menu
#  - Select this python file

import Ciros2 as Ciros
app = Ciros.Application()
env = Ciros.Environment()
env.selectElement('')


island_count = 0
def create_island( pose):
  global island_count
  island_count = island_count + 1
  island_name =  'Island_' + str(island_count)
  island_frame = Ciros.Frame(trn=[pose['x'], -1 * pose['y'], pose['z']], rot=[0, 0, 1, -1 * pose['c']])
  new_island = env.createObject(island_name)
  new_island.setFrame(island_frame)
  return new_island

def add_station_from_library(library_path, island, station_fv_pose, station_fv_offset, resource_ids):
  new_station = Ciros.Object(env.addModelFromModLib(library_path)[0])
 
  station_frame = Ciros.Frame(trn=[station_fv_pose['x'], -1 * station_fv_pose['y'], 0], rot=[0, 0, 1, -1 * (station_fv_pose['c'] + station_fv_offset['c'])])
  original_offset = Ciros.Frame(trn=[station_fv_offset['x'], station_fv_offset['y'], station_fv_offset['z']], rot=[0,0,1,0])
  rotated_offset = Ciros.Frame(trn=[0,0,0], rot=[0, 0, 1, -1 * (station_fv_pose['c'] + station_fv_offset['c'])]) * original_offset
  offset_frame = Ciros.Frame(trn=rotated_offset.getTranslation(), rot=[0,0,1,0])
  new_station_frame = island.getFrame() * offset_frame * station_frame
  
  new_station.setFrame(new_station_frame)
  new_station.setParentObject(island.getName())
  
  plcs = find_plcs( new_station )
  for i in range(0, len(resource_ids)):
    if i >= len(plcs): break
    set_resource_id(plcs[i], resource_ids[i])
  
  return new_station

def find_plcs( station_object ):
  plc_list = []
  i = 0
  for n in station_object.getChildElementNameList( 'OBJ' ):
    if not n.startswith('SPS_') and not n.startswith('PLC_'): continue
    plc_list.append(Ciros.Object(n))
    i += 1  
  return( plc_list )

def set_resource_id(plc, resource_id):
  props = plc.getExtProps()
  found = False
  for prop in props:
    if prop[0] == 'MES_ResourceID':
      prop[1] = str(resource_id)
      found = True
  if not found:
    props.append(['MES_ResourceID', str(resource_id)])
    
  plc.setExtProps(props)
  
  # For MPS Stations
  try:
    I40 = plc.getInput("I40_Betrieb")
    I40.setVal(1)
  except:
    pass


###################################################################

island = create_island( { 'x': 3000, 'y': 3996.3219605262193, 'z': 0, 'c': -0.11704832845003921 } )

station = add_station_from_library(
  library_path = 'Festo CP System::CP-Lab::CP-L-iASRS12-W',
  island = island,
  station_fv_pose = { 'x': 3650.0000000000005, 'y': 6.139089236967266e-12, 'z': 0, 'c': -5040 },
  station_fv_offset = { 'x': 350, 'y': -190, 'z': 0, 'c': 0 },
  resource_ids = [7,] 
)


station = add_station_from_library(
  library_path = 'Festo CP System::CP-Lab::CP-L-iASRS12-W',
  island = island,
  station_fv_pose = { 'x': 2919.9999999999995, 'y': 3.524291969370097e-12, 'z': 0, 'c': -5400 },
  station_fv_offset = { 'x': 350, 'y': -190, 'z': 0, 'c': 0 },
  resource_ids = [6,] 
)


station = add_station_from_library(
  library_path = 'Festo CP System::CP-Lab::CP-L-CONVEYOR',
  island = island,
  station_fv_pose = { 'x': 2190.0000000000005, 'y': 3.240074875066057e-12, 'z': 0, 'c': -5760 },
  station_fv_offset = { 'x': 350, 'y': -190, 'z': 0, 'c': 0 },
  resource_ids = [5,] 
)

station = add_station_from_library(
  library_path = 'Festo CP System::CP-Lab::CP-L-iASRS12-W',
  island = island,
  station_fv_pose = { 'x': 1460.0000000000005, 'y': -3.552713678800501e-12, 'z': 0, 'c': -5760 },
  station_fv_offset = { 'x': 350, 'y': -190, 'z': 0, 'c': 0 },
  resource_ids = [4,] 
)


station = add_station_from_library(
  library_path = 'Festo CP System::CP-Lab::CP-L-CONVEYOR',
  island = island,
  station_fv_pose = { 'x': 730.0000000000016, 'y': -9.180212146020494e-12, 'z': 0, 'c': -6120 },
  station_fv_offset = { 'x': 350, 'y': -190, 'z': 0, 'c': 0 },
  resource_ids = [3,] 
)

station = add_station_from_library(
  library_path = 'Festo CP System::CP-Lab::CP-L-CONVEYOR',
  island = island,
  station_fv_pose = { 'x': 2.419398015263141e-12, 'y': -1.7337242752546445e-11, 'z': 0, 'c': -6480 },
  station_fv_offset = { 'x': 350, 'y': -190, 'z': 0, 'c': 0 },
  resource_ids = [2,] 
)

station = add_station_from_library(
  library_path = 'Festo CP System::CP-Lab::CP-L-CONVEYOR',
  island = island,
  station_fv_pose = { 'x': -730.0000000000006, 'y': -2.0094148567295633e-11, 'z': 0, 'c': -6840 },
  station_fv_offset = { 'x': 350, 'y': -190, 'z': 0, 'c': 0 },
  resource_ids = [1,] 
)

station = add_station_from_library(
  library_path = 'Festo CP System::CP Application::CP-AM-MAG_FRONT',
  island = island,
  station_fv_pose = { 'x': -583.0000000000005, 'y': 37.999999999979536, 'z': 0, 'c': -6840 },
  station_fv_offset = { 'x': 203, 'y': -97.45, 'z': 975, 'c': 0 },
  resource_ids = [] 
)

station = add_station_from_library(
  library_path = 'Festo CP System::CP Application::CP-AM-MEASURE',
  island = island,
  station_fv_pose = { 'x': 203.00000000000261, 'y': -12.000000000013557, 'z': 0, 'c': -6480 },
  station_fv_offset = { 'x': 147, 'y': -147.45, 'z': 975, 'c': 0 },
  resource_ids = [] 
)

station = add_station_from_library(
  library_path = 'Festo CP System::CP Application::CP-AM-MAG_BACK',
  island = island,
  station_fv_pose = { 'x': 877.0000000000011, 'y': 37.99999999999248, 'z': 0, 'c': -6120 },
  station_fv_offset = { 'x': 203, 'y': -97.45, 'z': 975, 'c': 0 },
  resource_ids = [] 
)

station = add_station_from_library(
  library_path = 'Festo CP System::CP Application::CP-AM-MPRESS',
  island = island,
  station_fv_pose = { 'x': 2430.0000000000005, 'y': 45.00000000000418, 'z': 0, 'c': -5760 },
  station_fv_offset = { 'x': 110, 'y': -90.45, 'z': 975, 'c': 0 },
  resource_ids = [] 
)


app.resetModel()